﻿//////////////////////////////////////////////
// MapRequestDescriptor.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkGraphics
#include "../Dll/DllDefines.h"

#include "../Utils/DxDefinesWrapper.h"

/// Internals --------------------------------

namespace nkGraphics
{
	struct BufferSubResourceDescriptor
	{
		unsigned int _subResourceIndex = 0 ;
	} ;

	struct TextureSubResourceDescriptor
	{
		unsigned int _indexInArray = 0 ;
		unsigned int _mipIndex = 0 ;
	} ;
}

/// Class ------------------------------------

namespace nkGraphics
{
	struct DLL_GRAPHICS_EXPORT MapRequestDescriptor
	{
		// Attributes
		// Map type wanted
		MAP _mapType = MAP_WRITE_DISCARD ;

		// Which sub resource should be mapped
		union
		{
			BufferSubResourceDescriptor _buffer ;
			TextureSubResourceDescriptor _texture = TextureSubResourceDescriptor() ;
		} ;

		// Functions
		// Constructors
		MapRequestDescriptor () = default ;

		MapRequestDescriptor (MAP mapType, unsigned int bufferSubResourceIndex)
		:	MapRequestDescriptor ()
		{
			_mapType = mapType ;
			_buffer._subResourceIndex = bufferSubResourceIndex ;
		}

		MapRequestDescriptor (MAP mapType, unsigned int textureIndexInArray, unsigned int textureMipIndex)
		:	MapRequestDescriptor ()
		{
			_mapType = mapType ;
			_texture._indexInArray = textureIndexInArray ;
			_texture._mipIndex = textureMipIndex ;
		}
	} ;
}